@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API license information
 * @property name The license name used for the API
 * @property url A URL to the license used for the API. MUST be in the format of a URL
 */
public data class ApiLicenseInformationResponse(
    public val name: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiLicenseInformationResponse): ApiLicenseInformationResponse = ApiLicenseInformationResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
