@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * API Management service resource SKU properties.
 * @property capacity Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
 * @property name Name of the Sku.
 */
public data class ApiManagementServiceSkuPropertiesResponse(
    public val capacity: Int,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiManagementServiceSkuPropertiesResponse): ApiManagementServiceSkuPropertiesResponse = ApiManagementServiceSkuPropertiesResponse(
            capacity = javaType.capacity(),
            name = javaType.name(),
        )
    }
}
