@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Control Plane Apis version constraint for the API Management service.
 * @property minApiVersion Limit control plane API calls to API Management service with version equal to or newer than this value.
 */
public data class ApiVersionConstraintResponse(
    public val minApiVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiVersionConstraintResponse): ApiVersionConstraintResponse = ApiVersionConstraintResponse(
            minApiVersion = javaType.minApiVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
