@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An API Version Set contains the common configuration for a set of API Versions relating
 * @property description Description of API Version Set.
 * @property id Identifier for existing API Version Set. Omit this value to create a new Version Set.
 * @property name The display Name of the API Version Set.
 * @property versionHeaderName Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
 * @property versionQueryName Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
 * @property versioningScheme An value that determines where the API Version identifier will be located in a HTTP request.
 */
public data class ApiVersionSetContractDetailsResponse(
    public val description: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val versionHeaderName: String? = null,
    public val versionQueryName: String? = null,
    public val versioningScheme: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiVersionSetContractDetailsResponse): ApiVersionSetContractDetailsResponse = ApiVersionSetContractDetailsResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            versionHeaderName = javaType.versionHeaderName().map({ args0 -> args0 }).orElse(null),
            versionQueryName = javaType.versionQueryName().map({ args0 -> args0 }).orElse(null),
            versioningScheme = javaType.versioningScheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
