@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Authorization Provider oauth2 grant types settings
 * @property authorizationCode OAuth2 authorization code grant parameters
 * @property clientCredentials OAuth2 client credential grant parameters
 */
public data class AuthorizationProviderOAuth2GrantTypesResponse(
    public val authorizationCode: Map<String, String>? = null,
    public val clientCredentials: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.AuthorizationProviderOAuth2GrantTypesResponse): AuthorizationProviderOAuth2GrantTypesResponse =
            AuthorizationProviderOAuth2GrantTypesResponse(
                authorizationCode = javaType.authorizationCode().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                clientCredentials = javaType.clientCredentials().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
