@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OAuth2 settings details
 * @property grantTypes OAuth2 settings
 * @property redirectUrl Redirect URL to be set in the OAuth application.
 */
public data class AuthorizationProviderOAuth2SettingsResponse(
    public val grantTypes: AuthorizationProviderOAuth2GrantTypesResponse? = null,
    public val redirectUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.AuthorizationProviderOAuth2SettingsResponse): AuthorizationProviderOAuth2SettingsResponse = AuthorizationProviderOAuth2SettingsResponse(
            grantTypes = javaType.grantTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationProviderOAuth2GrantTypesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redirectUrl = javaType.redirectUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
