@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorization header information.
 * @property parameter Authentication Parameter value.
 * @property scheme Authentication Scheme name.
 */
public data class BackendAuthorizationHeaderCredentialsResponse(
    public val parameter: String,
    public val scheme: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.BackendAuthorizationHeaderCredentialsResponse): BackendAuthorizationHeaderCredentialsResponse =
            BackendAuthorizationHeaderCredentialsResponse(
                parameter = javaType.parameter(),
                scheme = javaType.scheme(),
            )
    }
}
