@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Details of the Credentials used to connect to Backend.
 * @property authorization Authorization header authentication
 * @property certificate List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
 * @property certificateIds List of Client Certificate Ids.
 * @property header Header Parameter description.
 * @property query Query Parameter description.
 */
public data class BackendCredentialsContractResponse(
    public val authorization: BackendAuthorizationHeaderCredentialsResponse? = null,
    public val certificate: List<String>? = null,
    public val certificateIds: List<String>? = null,
    public val `header`: Map<String, List<String>>? = null,
    public val query: Map<String, List<String>>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.BackendCredentialsContractResponse): BackendCredentialsContractResponse = BackendCredentialsContractResponse(
            authorization = javaType.authorization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendAuthorizationHeaderCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            certificate = javaType.certificate().map({ args0 -> args0 }),
            certificateIds = javaType.certificateIds().map({ args0 -> args0 }),
            `header` = javaType.`header`().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0
                    }),
                )
            }).toMap(),
            query = javaType.query().map({ args0 -> args0.key.to(args0.value.map({ args0 -> args0 })) }).toMap(),
        )
    }
}
