@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers Masking settings for headers
 * @property queryParams Masking settings for Url query parameters
 */
public data class DataMaskingResponse(
    public val headers: List<DataMaskingEntityResponse>? = null,
    public val queryParams: List<DataMaskingEntityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.DataMaskingResponse): DataMaskingResponse = DataMaskingResponse(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.DataMaskingEntityResponse.Companion.toKotlin(args0)
                })
            }),
            queryParams = javaType.queryParams().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.DataMaskingEntityResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
