@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ApiRelease details.
 * @property apiId Identifier of the API the release belongs to.
 * @property createdDateTime The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property notes Release Notes
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedDateTime The time the API release was updated.
 */
public data class GetApiReleaseResult(
    public val apiId: String? = null,
    public val createdDateTime: String,
    public val id: String,
    public val name: String,
    public val notes: String? = null,
    public val type: String,
    public val updatedDateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiReleaseResult): GetApiReleaseResult = GetApiReleaseResult(
            apiId = javaType.apiId().map({ args0 -> args0 }).orElse(null),
            createdDateTime = javaType.createdDateTime(),
            id = javaType.id(),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedDateTime = javaType.updatedDateTime(),
        )
    }
}
