@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contract details.
 * @property description Description of the Tag.
 * @property displayName Tag name.
 * @property externalDocsDescription Description of the external resources describing the tag.
 * @property externalDocsUrl Absolute URL of external resources describing the tag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property tagId Identifier of the tag in the form of /tags/{tagId}
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApiTagDescriptionResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val externalDocsDescription: String? = null,
    public val externalDocsUrl: String? = null,
    public val id: String,
    public val name: String,
    public val tagId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiTagDescriptionResult): GetApiTagDescriptionResult = GetApiTagDescriptionResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            externalDocsDescription = javaType.externalDocsDescription().map({ args0 -> args0 }).orElse(null),
            externalDocsUrl = javaType.externalDocsUrl().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            tagId = javaType.tagId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
