@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API Version Set Contract details.
 * @property description Description of API Version Set.
 * @property displayName Name of API Version Set
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property versionHeaderName Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
 * @property versionQueryName Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
 * @property versioningScheme An value that determines where the API Version identifier will be located in a HTTP request.
 */
public data class GetApiVersionSetResult(
    public val description: String? = null,
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val type: String,
    public val versionHeaderName: String? = null,
    public val versionQueryName: String? = null,
    public val versioningScheme: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiVersionSetResult): GetApiVersionSetResult = GetApiVersionSetResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            versionHeaderName = javaType.versionHeaderName().map({ args0 -> args0 }).orElse(null),
            versionQueryName = javaType.versionQueryName().map({ args0 -> args0 }).orElse(null),
            versioningScheme = javaType.versioningScheme(),
        )
    }
}
