@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Wiki properties
 * @property documents Collection wiki documents included into this wiki.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApiWikiResult(
    public val documents: List<WikiDocumentationContractResponse>? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiWikiResult): GetApiWikiResult = GetApiWikiResult(
            documents = javaType.documents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.WikiDocumentationContractResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
