@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorization Provider contract.
 * @property displayName Authorization Provider name. Must be 1 to 300 characters long.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identityProvider Identity provider name. Must be 1 to 300 characters long.
 * @property name The name of the resource
 * @property oauth2 OAuth2 settings
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAuthorizationProviderResult(
    public val displayName: String? = null,
    public val id: String,
    public val identityProvider: String? = null,
    public val name: String,
    public val oauth2: AuthorizationProviderOAuth2SettingsResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetAuthorizationProviderResult): GetAuthorizationProviderResult = GetAuthorizationProviderResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identityProvider = javaType.identityProvider().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            oauth2 = javaType.oauth2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationProviderOAuth2SettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
