@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Backend details.
 * @property credentials Backend Credentials Contract Properties
 * @property description Backend Description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties Backend Properties contract
 * @property protocol Backend communication protocol.
 * @property proxy Backend gateway Contract Properties
 * @property resourceId Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps.
 * @property title Backend Title.
 * @property tls Backend TLS Properties
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property url Runtime Url of the Backend.
 */
public data class GetBackendResult(
    public val credentials: BackendCredentialsContractResponse? = null,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val properties: BackendPropertiesResponse,
    public val protocol: String,
    public val proxy: BackendProxyContractResponse? = null,
    public val resourceId: String? = null,
    public val title: String? = null,
    public val tls: BackendTlsPropertiesResponse? = null,
    public val type: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetBackendResult): GetBackendResult = GetBackendResult(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendCredentialsContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendPropertiesResponse.Companion.toKotlin(args0)
            }),
            protocol = javaType.protocol(),
            proxy = javaType.proxy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendProxyContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendTlsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
        )
    }
}
