@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Certificate details.
 * @property expirationDate Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property keyVault KeyVault location details of the certificate.
 * @property name The name of the resource
 * @property subject Subject attribute of the certificate.
 * @property thumbprint Thumbprint of the certificate.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCertificateResult(
    public val expirationDate: String,
    public val id: String,
    public val keyVault: KeyVaultContractPropertiesResponse? = null,
    public val name: String,
    public val subject: String,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            expirationDate = javaType.expirationDate(),
            id = javaType.id(),
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.KeyVaultContractPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            subject = javaType.subject(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
