@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Email Template details.
 * @property body Email Template Body. This should be a valid XDocument
 * @property description Description of the Email Template.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isDefault Whether the template is the default template provided by API Management or has been edited.
 * @property name The name of the resource
 * @property parameters Email Template Parameter values.
 * @property subject Subject of the Template.
 * @property title Title of the Template.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEmailTemplateResult(
    public val body: String,
    public val description: String? = null,
    public val id: String,
    public val isDefault: Boolean,
    public val name: String,
    public val parameters: List<EmailTemplateParametersContractPropertiesResponse>? = null,
    public val subject: String,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetEmailTemplateResult): GetEmailTemplateResult = GetEmailTemplateResult(
            body = javaType.body(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isDefault = javaType.isDefault(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.EmailTemplateParametersContractPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            subject = javaType.subject(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
