@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Gateway certificate authority details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isTrusted Determines whether certificate authority is trusted.
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGatewayCertificateAuthorityResult(
    public val id: String,
    public val isTrusted: Boolean? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetGatewayCertificateAuthorityResult): GetGatewayCertificateAuthorityResult = GetGatewayCertificateAuthorityResult(
            id = javaType.id(),
            isTrusted = javaType.isTrusted().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
