@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Gateway hostname configuration details.
 * @property certificateId Identifier of Certificate entity that will be used for TLS connection establishment
 * @property hostname Hostname value. Supports valid domain name, partial or full wildcard
 * @property http2Enabled Specifies if HTTP/2.0 is supported
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property negotiateClientCertificate Determines whether gateway requests client certificate
 * @property tls10Enabled Specifies if TLS 1.0 is supported
 * @property tls11Enabled Specifies if TLS 1.1 is supported
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGatewayHostnameConfigurationResult(
    public val certificateId: String? = null,
    public val hostname: String? = null,
    public val http2Enabled: Boolean? = null,
    public val id: String,
    public val name: String,
    public val negotiateClientCertificate: Boolean? = null,
    public val tls10Enabled: Boolean? = null,
    public val tls11Enabled: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetGatewayHostnameConfigurationResult): GetGatewayHostnameConfigurationResult = GetGatewayHostnameConfigurationResult(
            certificateId = javaType.certificateId().map({ args0 -> args0 }).orElse(null),
            hostname = javaType.hostname().map({ args0 -> args0 }).orElse(null),
            http2Enabled = javaType.http2Enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            negotiateClientCertificate = javaType.negotiateClientCertificate().map({ args0 ->
                args0
            }).orElse(null),
            tls10Enabled = javaType.tls10Enabled().map({ args0 -> args0 }).orElse(null),
            tls11Enabled = javaType.tls11Enabled().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
