@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gateway details.
 * @property description Gateway description
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property locationData Gateway location.
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGatewayResult(
    public val description: String? = null,
    public val id: String,
    public val locationData: ResourceLocationDataContractResponse? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetGatewayResult): GetGatewayResult = GetGatewayResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            locationData = javaType.locationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ResourceLocationDataContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
