@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * GraphQL API Resolver details.
 * @property description Description of the resolver. May include HTML formatting tags.
 * @property displayName Resolver Name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property path Path is type/field being resolved.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGraphQLApiResolverResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val path: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetGraphQLApiResolverResult): GetGraphQLApiResolverResult = GetGraphQLApiResolverResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
