@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Identity Provider details.
 * @property allowedTenants List of Allowed Tenants when configuring Azure Active Directory login.
 * @property authority OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
 * @property clientId Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
 * @property clientLibrary The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
 * @property clientSecret Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property passwordResetPolicyName Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
 * @property profileEditingPolicyName Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
 * @property signinPolicyName Signin Policy Name. Only applies to AAD B2C Identity Provider.
 * @property signinTenant The TenantId to use instead of Common when logging into Active Directory
 * @property signupPolicyName Signup Policy Name. Only applies to AAD B2C Identity Provider.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIdentityProviderResult(
    public val allowedTenants: List<String>? = null,
    public val authority: String? = null,
    public val clientId: String,
    public val clientLibrary: String? = null,
    public val clientSecret: String? = null,
    public val id: String,
    public val name: String,
    public val passwordResetPolicyName: String? = null,
    public val profileEditingPolicyName: String? = null,
    public val signinPolicyName: String? = null,
    public val signinTenant: String? = null,
    public val signupPolicyName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetIdentityProviderResult): GetIdentityProviderResult = GetIdentityProviderResult(
            allowedTenants = javaType.allowedTenants().map({ args0 -> args0 }),
            authority = javaType.authority().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId(),
            clientLibrary = javaType.clientLibrary().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            passwordResetPolicyName = javaType.passwordResetPolicyName().map({ args0 -> args0 }).orElse(null),
            profileEditingPolicyName = javaType.profileEditingPolicyName().map({ args0 -> args0 }).orElse(null),
            signinPolicyName = javaType.signinPolicyName().map({ args0 -> args0 }).orElse(null),
            signinTenant = javaType.signinTenant().map({ args0 -> args0 }).orElse(null),
            signupPolicyName = javaType.signupPolicyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
