@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NamedValue details.
 * @property displayName Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property keyVault KeyVault location details of the namedValue.
 * @property name The name of the resource
 * @property secret Determines whether the value is a secret and should be encrypted or not. Default value is false.
 * @property tags Optional tags that when provided can be used to filter the NamedValue list.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 */
public data class GetNamedValueResult(
    public val displayName: String,
    public val id: String,
    public val keyVault: KeyVaultContractPropertiesResponse? = null,
    public val name: String,
    public val secret: Boolean? = null,
    public val tags: List<String>? = null,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetNamedValueResult): GetNamedValueResult = GetNamedValueResult(
            displayName = javaType.displayName(),
            id = javaType.id(),
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.KeyVaultContractPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            secret = javaType.secret().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0 }),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
