@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Policy restriction contract details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property requireBase Indicates if base policy should be enforced for the policy document.
 * @property scope Path to the policy document.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPolicyRestrictionResult(
    public val id: String,
    public val name: String,
    public val requireBase: String? = null,
    public val scope: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetPolicyRestrictionResult): GetPolicyRestrictionResult = GetPolicyRestrictionResult(
            id = javaType.id(),
            name = javaType.name(),
            requireBase = javaType.requireBase().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
