@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tag-API link details.
 * @property apiId Full resource Id of an API.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTagApiLinkResult(
    public val apiId: String,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetTagApiLinkResult): GetTagApiLinkResult = GetTagApiLinkResult(
            apiId = javaType.apiId(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
