@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tag Contract details.
 * @property displayName Tag name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTagByApiResult(
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetTagByApiResult): GetTagByApiResult = GetTagByApiResult(
            displayName = javaType.displayName(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
