@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * User details.
 * @property email Email address.
 * @property firstName First name.
 * @property groups Collection of groups user is part of.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identities Collection of user identities.
 * @property lastName Last name.
 * @property name The name of the resource
 * @property note Optional note about a user set by the administrator.
 * @property registrationDate Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property state Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUserResult(
    public val email: String? = null,
    public val firstName: String? = null,
    public val groups: List<GroupContractPropertiesResponse>,
    public val id: String,
    public val identities: List<UserIdentityContractResponse>? = null,
    public val lastName: String? = null,
    public val name: String,
    public val note: String? = null,
    public val registrationDate: String? = null,
    public val state: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetUserResult): GetUserResult = GetUserResult(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.GroupContractPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identities = javaType.identities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.UserIdentityContractResponse.Companion.toKotlin(args0)
                })
            }),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            note = javaType.note().map({ args0 -> args0 }).orElse(null),
            registrationDate = javaType.registrationDate().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
