@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * API Schema Contract details.
 * @property components Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
 * @property contentType Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br> - `Swagger` Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
 * @property definitions Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
 */
public data class GetWorkspaceApiSchemaResult(
    public val components: Any? = null,
    public val contentType: String,
    public val definitions: Any? = null,
    public val id: String,
    public val name: String,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetWorkspaceApiSchemaResult): GetWorkspaceApiSchemaResult = GetWorkspaceApiSchemaResult(
            components = javaType.components().map({ args0 -> args0 }).orElse(null),
            contentType = javaType.contentType(),
            definitions = javaType.definitions().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
