@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Global Schema Contract details.
 * @property description Free-form schema entity description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property schemaType Schema Type. Immutable.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Json-encoded string for non json-based schema.
 */
public data class GetWorkspaceGlobalSchemaResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val schemaType: String,
    public val type: String,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetWorkspaceGlobalSchemaResult): GetWorkspaceGlobalSchemaResult = GetWorkspaceGlobalSchemaResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            schemaType = javaType.schemaType(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
