@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Product details.
 * @property approvalRequired whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
 * @property description Product description. May include HTML formatting tags.
 * @property displayName Product name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property state whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished.
 * @property subscriptionRequired Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
 * @property subscriptionsLimit Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
 * @property terms Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceProductResult(
    public val approvalRequired: Boolean? = null,
    public val description: String? = null,
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val state: String? = null,
    public val subscriptionRequired: Boolean? = null,
    public val subscriptionsLimit: Int? = null,
    public val terms: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetWorkspaceProductResult): GetWorkspaceProductResult = GetWorkspaceProductResult(
            approvalRequired = javaType.approvalRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            subscriptionRequired = javaType.subscriptionRequired().map({ args0 -> args0 }).orElse(null),
            subscriptionsLimit = javaType.subscriptionsLimit().map({ args0 -> args0 }).orElse(null),
            terms = javaType.terms().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
