@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tag-product link details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property productId Full resource Id of a product.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceTagProductLinkResult(
    public val id: String,
    public val name: String,
    public val productId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetWorkspaceTagProductLinkResult): GetWorkspaceTagProductLinkResult = GetWorkspaceTagProductLinkResult(
            id = javaType.id(),
            name = javaType.name(),
            productId = javaType.productId(),
            type = javaType.type(),
        )
    }
}
