@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Group contract Properties.
 * @property builtIn true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
 * @property description Group description. Can contain HTML formatting tags.
 * @property displayName Group name.
 * @property externalId For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
 * @property type Group type.
 */
public data class GroupContractPropertiesResponse(
    public val builtIn: Boolean,
    public val description: String? = null,
    public val displayName: String,
    public val externalId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GroupContractPropertiesResponse): GroupContractPropertiesResponse = GroupContractPropertiesResponse(
            builtIn = javaType.builtIn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            externalId = javaType.externalId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
