@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * KeyVault contract details.
 * @property identityClientId Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
 * @property lastStatus Last time sync and refresh status of secret from key vault.
 * @property secretIdentifier Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi
 */
public data class KeyVaultContractPropertiesResponse(
    public val identityClientId: String? = null,
    public val lastStatus: KeyVaultLastAccessStatusContractPropertiesResponse? = null,
    public val secretIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.KeyVaultContractPropertiesResponse): KeyVaultContractPropertiesResponse = KeyVaultContractPropertiesResponse(
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            lastStatus = javaType.lastStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.KeyVaultLastAccessStatusContractPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secretIdentifier = javaType.secretIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
