@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OAuth Server Secrets Contract.
 * @property clientSecret oAuth Authorization Server Secrets.
 * @property resourceOwnerPassword Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
 * @property resourceOwnerUsername Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
 */
public data class ListAuthorizationServerSecretsResult(
    public val clientSecret: String? = null,
    public val resourceOwnerPassword: String? = null,
    public val resourceOwnerUsername: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ListAuthorizationServerSecretsResult): ListAuthorizationServerSecretsResult = ListAuthorizationServerSecretsResult(
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            resourceOwnerPassword = javaType.resourceOwnerPassword().map({ args0 -> args0 }).orElse(null),
            resourceOwnerUsername = javaType.resourceOwnerUsername().map({ args0 -> args0 }).orElse(null),
        )
    }
}
