@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 * @property validationKey This is secret value of the validation key in portal settings.
 */
public data class ListDelegationSettingSecretsResult(
    public val validationKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ListDelegationSettingSecretsResult): ListDelegationSettingSecretsResult = ListDelegationSettingSecretsResult(
            validationKey = javaType.validationKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
