@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Tenant access information contract of the API Management service.
 * @property enabled Determines whether direct access is enabled.
 * @property id Access Information type ('access' or 'gitAccess')
 * @property primaryKey Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property principalId Principal (User) Identifier.
 * @property secondaryKey Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 */
public data class ListTenantAccessSecretsResult(
    public val enabled: Boolean? = null,
    public val id: String? = null,
    public val primaryKey: String? = null,
    public val principalId: String? = null,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ListTenantAccessSecretsResult): ListTenantAccessSecretsResult = ListTenantAccessSecretsResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
