@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Operation parameters details.
 * @property defaultValue Default parameter value.
 * @property description Parameter description.
 * @property examples Exampled defined for the parameter.
 * @property name Parameter name.
 * @property required Specifies whether parameter is required or not.
 * @property schemaId Schema identifier.
 * @property type Parameter type.
 * @property typeName Type name defined by the schema.
 * @property values Parameter values.
 */
public data class ParameterContractResponse(
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val examples: Map<String, ParameterExampleContractResponse>? = null,
    public val name: String,
    public val required: Boolean? = null,
    public val schemaId: String? = null,
    public val type: String,
    public val typeName: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ParameterContractResponse): ParameterContractResponse = ParameterContractResponse(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            examples = javaType.examples().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterExampleContractResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            name = javaType.name(),
            required = javaType.required().map({ args0 -> args0 }).orElse(null),
            schemaId = javaType.schemaId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            typeName = javaType.typeName().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
