@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Parameter example.
 * @property description Long description for the example
 * @property externalValue A URL that points to the literal example
 * @property summary Short description for the example
 * @property value Example value. May be a primitive value, or an object.
 */
public data class ParameterExampleContractResponse(
    public val description: String? = null,
    public val externalValue: String? = null,
    public val summary: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ParameterExampleContractResponse): ParameterExampleContractResponse = ParameterExampleContractResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            externalValue = javaType.externalValue().map({ args0 -> args0 }).orElse(null),
            summary = javaType.summary().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
