@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Suppress

/**
 * Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
 * @property request Diagnostic settings for request.
 * @property response Diagnostic settings for response.
 */
public data class PipelineDiagnosticSettingsResponse(
    public val request: HttpMessageDiagnosticResponse? = null,
    public val response: HttpMessageDiagnosticResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.PipelineDiagnosticSettingsResponse): PipelineDiagnosticSettingsResponse = PipelineDiagnosticSettingsResponse(
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.HttpMessageDiagnosticResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            response = javaType.response().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.HttpMessageDiagnosticResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
