@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Remote Private Endpoint Connection resource.
 * @property groupIds All the Group ids.
 * @property id Private Endpoint connection resource id
 * @property name Private Endpoint Connection Name
 * @property privateEndpoint The resource of private end point.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property provisioningState The provisioning state of the private endpoint connection resource.
 * @property type Private Endpoint Connection Resource Type
 */
public data class RemotePrivateEndpointConnectionWrapperResponse(
    public val groupIds: List<String>,
    public val id: String? = null,
    public val name: String? = null,
    public val privateEndpoint: ArmIdWrapperResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.RemotePrivateEndpointConnectionWrapperResponse): RemotePrivateEndpointConnectionWrapperResponse =
            RemotePrivateEndpointConnectionWrapperResponse(
                groupIds = javaType.groupIds().map({ args0 -> args0 }),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.apimanagement.kotlin.outputs.ArmIdWrapperResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                }),
                provisioningState = javaType.provisioningState(),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
