@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Sampling settings for Diagnostic.
 * @property percentage Rate of sampling for fixed-rate sampling.
 * @property samplingType Sampling type.
 */
public data class SamplingSettingsResponse(
    public val percentage: Double? = null,
    public val samplingType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.SamplingSettingsResponse): SamplingSettingsResponse = SamplingSettingsResponse(
            percentage = javaType.percentage().map({ args0 -> args0 }).orElse(null),
            samplingType = javaType.samplingType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
