@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User identity details.
 * @property id Identifier value within provider.
 * @property provider Identity provider name.
 */
public data class UserIdentityContractResponse(
    public val id: String? = null,
    public val provider: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.UserIdentityContractResponse): UserIdentityContractResponse = UserIdentityContractResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            provider = javaType.provider().map({ args0 -> args0 }).orElse(null),
        )
    }
}
