@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration of a virtual network to which API Management service is deployed.
 * @property subnetResourceId The full resource ID of a subnet in a virtual network to deploy the API Management service in.
 * @property subnetname The name of the subnet.
 * @property vnetid The virtual network ID. This is typically a GUID. Expect a null GUID by default.
 */
public data class VirtualNetworkConfigurationResponse(
    public val subnetResourceId: String? = null,
    public val subnetname: String,
    public val vnetid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.VirtualNetworkConfigurationResponse): VirtualNetworkConfigurationResponse = VirtualNetworkConfigurationResponse(
            subnetResourceId = javaType.subnetResourceId().map({ args0 -> args0 }).orElse(null),
            subnetname = javaType.subnetname(),
            vnetid = javaType.vnetid(),
        )
    }
}
