@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.AppFunctions.getAppResiliencyPlain
import com.pulumi.azurenative.app.AppFunctions.getBuildPlain
import com.pulumi.azurenative.app.AppFunctions.getBuilderPlain
import com.pulumi.azurenative.app.AppFunctions.getCertificatePlain
import com.pulumi.azurenative.app.AppFunctions.getConnectedEnvironmentPlain
import com.pulumi.azurenative.app.AppFunctions.getConnectedEnvironmentsCertificatePlain
import com.pulumi.azurenative.app.AppFunctions.getConnectedEnvironmentsDaprComponentPlain
import com.pulumi.azurenative.app.AppFunctions.getConnectedEnvironmentsStoragePlain
import com.pulumi.azurenative.app.AppFunctions.getContainerAppAuthTokenPlain
import com.pulumi.azurenative.app.AppFunctions.getContainerAppPlain
import com.pulumi.azurenative.app.AppFunctions.getContainerAppsAuthConfigPlain
import com.pulumi.azurenative.app.AppFunctions.getContainerAppsSourceControlPlain
import com.pulumi.azurenative.app.AppFunctions.getCustomDomainVerificationIdPlain
import com.pulumi.azurenative.app.AppFunctions.getDaprComponentPlain
import com.pulumi.azurenative.app.AppFunctions.getDaprComponentResiliencyPolicyPlain
import com.pulumi.azurenative.app.AppFunctions.getDaprSubscriptionPlain
import com.pulumi.azurenative.app.AppFunctions.getDotNetComponentPlain
import com.pulumi.azurenative.app.AppFunctions.getJavaComponentPlain
import com.pulumi.azurenative.app.AppFunctions.getJobPlain
import com.pulumi.azurenative.app.AppFunctions.getManagedCertificatePlain
import com.pulumi.azurenative.app.AppFunctions.getManagedEnvironmentAuthTokenPlain
import com.pulumi.azurenative.app.AppFunctions.getManagedEnvironmentPlain
import com.pulumi.azurenative.app.AppFunctions.getManagedEnvironmentsStoragePlain
import com.pulumi.azurenative.app.AppFunctions.listBuildAuthTokenPlain
import com.pulumi.azurenative.app.AppFunctions.listConnectedEnvironmentsDaprComponentSecretsPlain
import com.pulumi.azurenative.app.AppFunctions.listContainerAppCustomHostNameAnalysisPlain
import com.pulumi.azurenative.app.AppFunctions.listContainerAppSecretsPlain
import com.pulumi.azurenative.app.AppFunctions.listDaprComponentSecretsPlain
import com.pulumi.azurenative.app.AppFunctions.listJobSecretsPlain
import com.pulumi.azurenative.app.kotlin.inputs.GetAppResiliencyPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetAppResiliencyPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetBuildPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetBuildPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetBuilderPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetBuilderPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsCertificatePlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsCertificatePlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsDaprComponentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsDaprComponentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsStoragePlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetConnectedEnvironmentsStoragePlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppAuthTokenPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppAuthTokenPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppsAuthConfigPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppsAuthConfigPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppsSourceControlPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetContainerAppsSourceControlPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprComponentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprComponentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprComponentResiliencyPolicyPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprComponentResiliencyPolicyPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprSubscriptionPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetDaprSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetDotNetComponentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetDotNetComponentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetJavaComponentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetJavaComponentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedCertificatePlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedCertificatePlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentAuthTokenPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentAuthTokenPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentsStoragePlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.GetManagedEnvironmentsStoragePlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListBuildAuthTokenPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListBuildAuthTokenPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListConnectedEnvironmentsDaprComponentSecretsPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListConnectedEnvironmentsDaprComponentSecretsPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListContainerAppCustomHostNameAnalysisPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListContainerAppCustomHostNameAnalysisPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListContainerAppSecretsPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListContainerAppSecretsPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListDaprComponentSecretsPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListDaprComponentSecretsPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ListJobSecretsPlainArgs
import com.pulumi.azurenative.app.kotlin.inputs.ListJobSecretsPlainArgsBuilder
import com.pulumi.azurenative.app.kotlin.outputs.GetAppResiliencyResult
import com.pulumi.azurenative.app.kotlin.outputs.GetBuildResult
import com.pulumi.azurenative.app.kotlin.outputs.GetBuilderResult
import com.pulumi.azurenative.app.kotlin.outputs.GetCertificateResult
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsCertificateResult
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsDaprComponentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsStorageResult
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppAuthTokenResult
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppResult
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppsAuthConfigResult
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppsSourceControlResult
import com.pulumi.azurenative.app.kotlin.outputs.GetCustomDomainVerificationIdResult
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprComponentResiliencyPolicyResult
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprComponentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprSubscriptionResult
import com.pulumi.azurenative.app.kotlin.outputs.GetDotNetComponentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetJavaComponentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetJobResult
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedCertificateResult
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentAuthTokenResult
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentResult
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentsStorageResult
import com.pulumi.azurenative.app.kotlin.outputs.ListBuildAuthTokenResult
import com.pulumi.azurenative.app.kotlin.outputs.ListConnectedEnvironmentsDaprComponentSecretsResult
import com.pulumi.azurenative.app.kotlin.outputs.ListContainerAppCustomHostNameAnalysisResult
import com.pulumi.azurenative.app.kotlin.outputs.ListContainerAppSecretsResult
import com.pulumi.azurenative.app.kotlin.outputs.ListDaprComponentSecretsResult
import com.pulumi.azurenative.app.kotlin.outputs.ListJobSecretsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.GetAppResiliencyResult.Companion.toKotlin as getAppResiliencyResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetBuildResult.Companion.toKotlin as getBuildResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetBuilderResult.Companion.toKotlin as getBuilderResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentResult.Companion.toKotlin as getConnectedEnvironmentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsCertificateResult.Companion.toKotlin as getConnectedEnvironmentsCertificateResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsDaprComponentResult.Companion.toKotlin as getConnectedEnvironmentsDaprComponentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetConnectedEnvironmentsStorageResult.Companion.toKotlin as getConnectedEnvironmentsStorageResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppAuthTokenResult.Companion.toKotlin as getContainerAppAuthTokenResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppResult.Companion.toKotlin as getContainerAppResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppsAuthConfigResult.Companion.toKotlin as getContainerAppsAuthConfigResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetContainerAppsSourceControlResult.Companion.toKotlin as getContainerAppsSourceControlResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetCustomDomainVerificationIdResult.Companion.toKotlin as getCustomDomainVerificationIdResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprComponentResiliencyPolicyResult.Companion.toKotlin as getDaprComponentResiliencyPolicyResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprComponentResult.Companion.toKotlin as getDaprComponentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetDaprSubscriptionResult.Companion.toKotlin as getDaprSubscriptionResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetDotNetComponentResult.Companion.toKotlin as getDotNetComponentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetJavaComponentResult.Companion.toKotlin as getJavaComponentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedCertificateResult.Companion.toKotlin as getManagedCertificateResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentAuthTokenResult.Companion.toKotlin as getManagedEnvironmentAuthTokenResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentResult.Companion.toKotlin as getManagedEnvironmentResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GetManagedEnvironmentsStorageResult.Companion.toKotlin as getManagedEnvironmentsStorageResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListBuildAuthTokenResult.Companion.toKotlin as listBuildAuthTokenResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListConnectedEnvironmentsDaprComponentSecretsResult.Companion.toKotlin as listConnectedEnvironmentsDaprComponentSecretsResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListContainerAppCustomHostNameAnalysisResult.Companion.toKotlin as listContainerAppCustomHostNameAnalysisResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListContainerAppSecretsResult.Companion.toKotlin as listContainerAppSecretsResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListDaprComponentSecretsResult.Companion.toKotlin as listDaprComponentSecretsResultToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ListJobSecretsResult.Companion.toKotlin as listJobSecretsResultToKotlin

public object AppFunctions {
    /**
     * Get container app resiliency policy.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Configuration to setup App Resiliency
     */
    public suspend fun getAppResiliency(argument: GetAppResiliencyPlainArgs): GetAppResiliencyResult =
        getAppResiliencyResultToKotlin(getAppResiliencyPlain(argument.toJava()).await())

    /**
     * @see [getAppResiliency].
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Configuration to setup App Resiliency
     */
    public suspend fun getAppResiliency(
        appName: String,
        name: String,
        resourceGroupName: String,
    ): GetAppResiliencyResult {
        val argument = GetAppResiliencyPlainArgs(
            appName = appName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getAppResiliencyResultToKotlin(getAppResiliencyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAppResiliency].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetAppResiliencyPlainArgs].
     * @return Configuration to setup App Resiliency
     */
    public suspend fun getAppResiliency(argument: suspend GetAppResiliencyPlainArgsBuilder.() -> Unit): GetAppResiliencyResult {
        val builder = GetAppResiliencyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppResiliencyResultToKotlin(getAppResiliencyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BuildResource
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Information pertaining to an individual build.
     */
    public suspend fun getBuild(argument: GetBuildPlainArgs): GetBuildResult =
        getBuildResultToKotlin(getBuildPlain(argument.toJava()).await())

    /**
     * @see [getBuild].
     * @param buildName The name of a build.
     * @param builderName The name of the builder.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information pertaining to an individual build.
     */
    public suspend fun getBuild(
        buildName: String,
        builderName: String,
        resourceGroupName: String,
    ): GetBuildResult {
        val argument = GetBuildPlainArgs(
            buildName = buildName,
            builderName = builderName,
            resourceGroupName = resourceGroupName,
        )
        return getBuildResultToKotlin(getBuildPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuild].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetBuildPlainArgs].
     * @return Information pertaining to an individual build.
     */
    public suspend fun getBuild(argument: suspend GetBuildPlainArgsBuilder.() -> Unit): GetBuildResult {
        val builder = GetBuildPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildResultToKotlin(getBuildPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BuilderResource
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Information about the SourceToCloud builder resource.
     */
    public suspend fun getBuilder(argument: GetBuilderPlainArgs): GetBuilderResult =
        getBuilderResultToKotlin(getBuilderPlain(argument.toJava()).await())

    /**
     * @see [getBuilder].
     * @param builderName The name of the builder.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Information about the SourceToCloud builder resource.
     */
    public suspend fun getBuilder(builderName: String, resourceGroupName: String): GetBuilderResult {
        val argument = GetBuilderPlainArgs(
            builderName = builderName,
            resourceGroupName = resourceGroupName,
        )
        return getBuilderResultToKotlin(getBuilderPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuilder].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetBuilderPlainArgs].
     * @return Information about the SourceToCloud builder resource.
     */
    public suspend fun getBuilder(argument: suspend GetBuilderPlainArgsBuilder.() -> Unit): GetBuilderResult {
        val builder = GetBuilderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuilderResultToKotlin(getBuilderPlain(builtArgument.toJava()).await())
    }

    /**
     * Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param certificateName Name of the Certificate.
     * @param environmentName Name of the Managed Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getCertificate(
        certificateName: String,
        environmentName: String,
        resourceGroupName: String,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            certificateName = certificateName,
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit): GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the properties of an connectedEnvironment.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return An environment for Kubernetes cluster specialized for web workloads by Azure App Service
     */
    public suspend fun getConnectedEnvironment(argument: GetConnectedEnvironmentPlainArgs): GetConnectedEnvironmentResult =
        getConnectedEnvironmentResultToKotlin(getConnectedEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getConnectedEnvironment].
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An environment for Kubernetes cluster specialized for web workloads by Azure App Service
     */
    public suspend fun getConnectedEnvironment(
        connectedEnvironmentName: String,
        resourceGroupName: String,
    ): GetConnectedEnvironmentResult {
        val argument = GetConnectedEnvironmentPlainArgs(
            connectedEnvironmentName = connectedEnvironmentName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectedEnvironmentResultToKotlin(getConnectedEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetConnectedEnvironmentPlainArgs].
     * @return An environment for Kubernetes cluster specialized for web workloads by Azure App Service
     */
    public suspend fun getConnectedEnvironment(argument: suspend GetConnectedEnvironmentPlainArgsBuilder.() -> Unit): GetConnectedEnvironmentResult {
        val builder = GetConnectedEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedEnvironmentResultToKotlin(getConnectedEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getConnectedEnvironmentsCertificate(argument: GetConnectedEnvironmentsCertificatePlainArgs): GetConnectedEnvironmentsCertificateResult =
        getConnectedEnvironmentsCertificateResultToKotlin(getConnectedEnvironmentsCertificatePlain(argument.toJava()).await())

    /**
     * @see [getConnectedEnvironmentsCertificate].
     * @param certificateName Name of the Certificate.
     * @param connectedEnvironmentName Name of the Connected Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getConnectedEnvironmentsCertificate(
        certificateName: String,
        connectedEnvironmentName: String,
        resourceGroupName: String,
    ): GetConnectedEnvironmentsCertificateResult {
        val argument = GetConnectedEnvironmentsCertificatePlainArgs(
            certificateName = certificateName,
            connectedEnvironmentName = connectedEnvironmentName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectedEnvironmentsCertificateResultToKotlin(getConnectedEnvironmentsCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedEnvironmentsCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetConnectedEnvironmentsCertificatePlainArgs].
     * @return Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getConnectedEnvironmentsCertificate(argument: suspend GetConnectedEnvironmentsCertificatePlainArgsBuilder.() -> Unit): GetConnectedEnvironmentsCertificateResult {
        val builder = GetConnectedEnvironmentsCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedEnvironmentsCertificateResultToKotlin(getConnectedEnvironmentsCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Dapr Component.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Dapr Component.
     */
    public suspend fun getConnectedEnvironmentsDaprComponent(argument: GetConnectedEnvironmentsDaprComponentPlainArgs): GetConnectedEnvironmentsDaprComponentResult =
        getConnectedEnvironmentsDaprComponentResultToKotlin(getConnectedEnvironmentsDaprComponentPlain(argument.toJava()).await())

    /**
     * @see [getConnectedEnvironmentsDaprComponent].
     * @param componentName Name of the Dapr Component.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr Component.
     */
    public suspend fun getConnectedEnvironmentsDaprComponent(
        componentName: String,
        connectedEnvironmentName: String,
        resourceGroupName: String,
    ): GetConnectedEnvironmentsDaprComponentResult {
        val argument = GetConnectedEnvironmentsDaprComponentPlainArgs(
            componentName = componentName,
            connectedEnvironmentName = connectedEnvironmentName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectedEnvironmentsDaprComponentResultToKotlin(getConnectedEnvironmentsDaprComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedEnvironmentsDaprComponent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetConnectedEnvironmentsDaprComponentPlainArgs].
     * @return Dapr Component.
     */
    public suspend fun getConnectedEnvironmentsDaprComponent(argument: suspend GetConnectedEnvironmentsDaprComponentPlainArgsBuilder.() -> Unit): GetConnectedEnvironmentsDaprComponentResult {
        val builder = GetConnectedEnvironmentsDaprComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedEnvironmentsDaprComponentResultToKotlin(getConnectedEnvironmentsDaprComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get storage for a connectedEnvironment.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Storage resource for connectedEnvironment.
     */
    public suspend fun getConnectedEnvironmentsStorage(argument: GetConnectedEnvironmentsStoragePlainArgs): GetConnectedEnvironmentsStorageResult =
        getConnectedEnvironmentsStorageResultToKotlin(getConnectedEnvironmentsStoragePlain(argument.toJava()).await())

    /**
     * @see [getConnectedEnvironmentsStorage].
     * @param connectedEnvironmentName Name of the Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageName Name of the storage.
     * @return Storage resource for connectedEnvironment.
     */
    public suspend fun getConnectedEnvironmentsStorage(
        connectedEnvironmentName: String,
        resourceGroupName: String,
        storageName: String,
    ): GetConnectedEnvironmentsStorageResult {
        val argument = GetConnectedEnvironmentsStoragePlainArgs(
            connectedEnvironmentName = connectedEnvironmentName,
            resourceGroupName = resourceGroupName,
            storageName = storageName,
        )
        return getConnectedEnvironmentsStorageResultToKotlin(getConnectedEnvironmentsStoragePlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedEnvironmentsStorage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetConnectedEnvironmentsStoragePlainArgs].
     * @return Storage resource for connectedEnvironment.
     */
    public suspend fun getConnectedEnvironmentsStorage(argument: suspend GetConnectedEnvironmentsStoragePlainArgsBuilder.() -> Unit): GetConnectedEnvironmentsStorageResult {
        val builder = GetConnectedEnvironmentsStoragePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedEnvironmentsStorageResultToKotlin(getConnectedEnvironmentsStoragePlain(builtArgument.toJava()).await())
    }

    /**
     * Container App.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container App.
     */
    public suspend fun getContainerApp(argument: GetContainerAppPlainArgs): GetContainerAppResult =
        getContainerAppResultToKotlin(getContainerAppPlain(argument.toJava()).await())

    /**
     * @see [getContainerApp].
     * @param containerAppName Name of the Container App.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Container App.
     */
    public suspend fun getContainerApp(containerAppName: String, resourceGroupName: String): GetContainerAppResult {
        val argument = GetContainerAppPlainArgs(
            containerAppName = containerAppName,
            resourceGroupName = resourceGroupName,
        )
        return getContainerAppResultToKotlin(getContainerAppPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerApp].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetContainerAppPlainArgs].
     * @return Container App.
     */
    public suspend fun getContainerApp(argument: suspend GetContainerAppPlainArgsBuilder.() -> Unit): GetContainerAppResult {
        val builder = GetContainerAppPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerAppResultToKotlin(getContainerAppPlain(builtArgument.toJava()).await())
    }

    /**
     * Container App Auth Token.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container App Auth Token.
     */
    public suspend fun getContainerAppAuthToken(argument: GetContainerAppAuthTokenPlainArgs): GetContainerAppAuthTokenResult =
        getContainerAppAuthTokenResultToKotlin(getContainerAppAuthTokenPlain(argument.toJava()).await())

    /**
     * @see [getContainerAppAuthToken].
     * @param containerAppName Name of the Container App.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Container App Auth Token.
     */
    public suspend fun getContainerAppAuthToken(containerAppName: String, resourceGroupName: String): GetContainerAppAuthTokenResult {
        val argument = GetContainerAppAuthTokenPlainArgs(
            containerAppName = containerAppName,
            resourceGroupName = resourceGroupName,
        )
        return getContainerAppAuthTokenResultToKotlin(getContainerAppAuthTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerAppAuthToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetContainerAppAuthTokenPlainArgs].
     * @return Container App Auth Token.
     */
    public suspend fun getContainerAppAuthToken(argument: suspend GetContainerAppAuthTokenPlainArgsBuilder.() -> Unit): GetContainerAppAuthTokenResult {
        val builder = GetContainerAppAuthTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerAppAuthTokenResultToKotlin(getContainerAppAuthTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
     */
    public suspend fun getContainerAppsAuthConfig(argument: GetContainerAppsAuthConfigPlainArgs): GetContainerAppsAuthConfigResult =
        getContainerAppsAuthConfigResultToKotlin(getContainerAppsAuthConfigPlain(argument.toJava()).await())

    /**
     * @see [getContainerAppsAuthConfig].
     * @param authConfigName Name of the Container App AuthConfig.
     * @param containerAppName Name of the Container App.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
     */
    public suspend fun getContainerAppsAuthConfig(
        authConfigName: String,
        containerAppName: String,
        resourceGroupName: String,
    ): GetContainerAppsAuthConfigResult {
        val argument = GetContainerAppsAuthConfigPlainArgs(
            authConfigName = authConfigName,
            containerAppName = containerAppName,
            resourceGroupName = resourceGroupName,
        )
        return getContainerAppsAuthConfigResultToKotlin(getContainerAppsAuthConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerAppsAuthConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetContainerAppsAuthConfigPlainArgs].
     * @return Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
     */
    public suspend fun getContainerAppsAuthConfig(argument: suspend GetContainerAppsAuthConfigPlainArgsBuilder.() -> Unit): GetContainerAppsAuthConfigResult {
        val builder = GetContainerAppsAuthConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerAppsAuthConfigResultToKotlin(getContainerAppsAuthConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Container App SourceControl.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container App SourceControl.
     */
    public suspend fun getContainerAppsSourceControl(argument: GetContainerAppsSourceControlPlainArgs): GetContainerAppsSourceControlResult =
        getContainerAppsSourceControlResultToKotlin(getContainerAppsSourceControlPlain(argument.toJava()).await())

    /**
     * @see [getContainerAppsSourceControl].
     * @param containerAppName Name of the Container App.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sourceControlName Name of the Container App SourceControl.
     * @return Container App SourceControl.
     */
    public suspend fun getContainerAppsSourceControl(
        containerAppName: String,
        resourceGroupName: String,
        sourceControlName: String,
    ): GetContainerAppsSourceControlResult {
        val argument = GetContainerAppsSourceControlPlainArgs(
            containerAppName = containerAppName,
            resourceGroupName = resourceGroupName,
            sourceControlName = sourceControlName,
        )
        return getContainerAppsSourceControlResultToKotlin(getContainerAppsSourceControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerAppsSourceControl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetContainerAppsSourceControlPlainArgs].
     * @return Container App SourceControl.
     */
    public suspend fun getContainerAppsSourceControl(argument: suspend GetContainerAppsSourceControlPlainArgsBuilder.() -> Unit): GetContainerAppsSourceControlResult {
        val builder = GetContainerAppsSourceControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerAppsSourceControlResultToKotlin(getContainerAppsSourceControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the verification id of a subscription used for verifying custom domains
     * Azure REST API version: 2023-05-02-preview.
     * Other available API versions: 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Custom domain verification Id of a subscription
     */
    public suspend fun getCustomDomainVerificationId(): GetCustomDomainVerificationIdResult =
        getCustomDomainVerificationIdResultToKotlin(getCustomDomainVerificationIdPlain().await())

    /**
     * Dapr Component.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Dapr Component.
     */
    public suspend fun getDaprComponent(argument: GetDaprComponentPlainArgs): GetDaprComponentResult =
        getDaprComponentResultToKotlin(getDaprComponentPlain(argument.toJava()).await())

    /**
     * @see [getDaprComponent].
     * @param componentName Name of the Dapr Component.
     * @param environmentName Name of the Managed Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr Component.
     */
    public suspend fun getDaprComponent(
        componentName: String,
        environmentName: String,
        resourceGroupName: String,
    ): GetDaprComponentResult {
        val argument = GetDaprComponentPlainArgs(
            componentName = componentName,
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return getDaprComponentResultToKotlin(getDaprComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDaprComponent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetDaprComponentPlainArgs].
     * @return Dapr Component.
     */
    public suspend fun getDaprComponent(argument: suspend GetDaprComponentPlainArgsBuilder.() -> Unit): GetDaprComponentResult {
        val builder = GetDaprComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDaprComponentResultToKotlin(getDaprComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Dapr Component Resiliency Policy.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Dapr Component Resiliency Policy.
     */
    public suspend fun getDaprComponentResiliencyPolicy(argument: GetDaprComponentResiliencyPolicyPlainArgs): GetDaprComponentResiliencyPolicyResult =
        getDaprComponentResiliencyPolicyResultToKotlin(getDaprComponentResiliencyPolicyPlain(argument.toJava()).await())

    /**
     * @see [getDaprComponentResiliencyPolicy].
     * @param componentName Name of the Dapr Component.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr Component Resiliency Policy.
     */
    public suspend fun getDaprComponentResiliencyPolicy(
        componentName: String,
        environmentName: String,
        name: String,
        resourceGroupName: String,
    ): GetDaprComponentResiliencyPolicyResult {
        val argument = GetDaprComponentResiliencyPolicyPlainArgs(
            componentName = componentName,
            environmentName = environmentName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getDaprComponentResiliencyPolicyResultToKotlin(getDaprComponentResiliencyPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDaprComponentResiliencyPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetDaprComponentResiliencyPolicyPlainArgs].
     * @return Dapr Component Resiliency Policy.
     */
    public suspend fun getDaprComponentResiliencyPolicy(argument: suspend GetDaprComponentResiliencyPolicyPlainArgsBuilder.() -> Unit): GetDaprComponentResiliencyPolicyResult {
        val builder = GetDaprComponentResiliencyPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDaprComponentResiliencyPolicyResultToKotlin(getDaprComponentResiliencyPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Dapr PubSub Event Subscription.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Dapr PubSub Event Subscription.
     */
    public suspend fun getDaprSubscription(argument: GetDaprSubscriptionPlainArgs): GetDaprSubscriptionResult =
        getDaprSubscriptionResultToKotlin(getDaprSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getDaprSubscription].
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Dapr subscription.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr PubSub Event Subscription.
     */
    public suspend fun getDaprSubscription(
        environmentName: String,
        name: String,
        resourceGroupName: String,
    ): GetDaprSubscriptionResult {
        val argument = GetDaprSubscriptionPlainArgs(
            environmentName = environmentName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getDaprSubscriptionResultToKotlin(getDaprSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDaprSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetDaprSubscriptionPlainArgs].
     * @return Dapr PubSub Event Subscription.
     */
    public suspend fun getDaprSubscription(argument: suspend GetDaprSubscriptionPlainArgsBuilder.() -> Unit): GetDaprSubscriptionResult {
        val builder = GetDaprSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDaprSubscriptionResultToKotlin(getDaprSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * .NET Component.
     * Azure REST API version: 2023-11-02-preview.
     * @param argument null
     * @return .NET Component.
     */
    public suspend fun getDotNetComponent(argument: GetDotNetComponentPlainArgs): GetDotNetComponentResult =
        getDotNetComponentResultToKotlin(getDotNetComponentPlain(argument.toJava()).await())

    /**
     * @see [getDotNetComponent].
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return .NET Component.
     */
    public suspend fun getDotNetComponent(
        environmentName: String,
        name: String,
        resourceGroupName: String,
    ): GetDotNetComponentResult {
        val argument = GetDotNetComponentPlainArgs(
            environmentName = environmentName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getDotNetComponentResultToKotlin(getDotNetComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDotNetComponent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetDotNetComponentPlainArgs].
     * @return .NET Component.
     */
    public suspend fun getDotNetComponent(argument: suspend GetDotNetComponentPlainArgsBuilder.() -> Unit): GetDotNetComponentResult {
        val builder = GetDotNetComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDotNetComponentResultToKotlin(getDotNetComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Java Component.
     * Azure REST API version: 2023-11-02-preview.
     * @param argument null
     * @return Java Component.
     */
    public suspend fun getJavaComponent(argument: GetJavaComponentPlainArgs): GetJavaComponentResult =
        getJavaComponentResultToKotlin(getJavaComponentPlain(argument.toJava()).await())

    /**
     * @see [getJavaComponent].
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Java Component.
     */
    public suspend fun getJavaComponent(
        environmentName: String,
        name: String,
        resourceGroupName: String,
    ): GetJavaComponentResult {
        val argument = GetJavaComponentPlainArgs(
            environmentName = environmentName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getJavaComponentResultToKotlin(getJavaComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getJavaComponent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetJavaComponentPlainArgs].
     * @return Java Component.
     */
    public suspend fun getJavaComponent(argument: suspend GetJavaComponentPlainArgsBuilder.() -> Unit): GetJavaComponentResult {
        val builder = GetJavaComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJavaComponentResultToKotlin(getJavaComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Container App Job
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container App Job
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param jobName Job Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Container App Job
     */
    public suspend fun getJob(jobName: String, resourceGroupName: String): GetJobResult {
        val argument = GetJobPlainArgs(
            jobName = jobName,
            resourceGroupName = resourceGroupName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return Container App Job
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getManagedCertificate(argument: GetManagedCertificatePlainArgs): GetManagedCertificateResult =
        getManagedCertificateResultToKotlin(getManagedCertificatePlain(argument.toJava()).await())

    /**
     * @see [getManagedCertificate].
     * @param environmentName Name of the Managed Environment.
     * @param managedCertificateName Name of the Managed Certificate.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getManagedCertificate(
        environmentName: String,
        managedCertificateName: String,
        resourceGroupName: String,
    ): GetManagedCertificateResult {
        val argument = GetManagedCertificatePlainArgs(
            environmentName = environmentName,
            managedCertificateName = managedCertificateName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedCertificateResultToKotlin(getManagedCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetManagedCertificatePlainArgs].
     * @return Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
     */
    public suspend fun getManagedCertificate(argument: suspend GetManagedCertificatePlainArgsBuilder.() -> Unit): GetManagedCertificateResult {
        val builder = GetManagedCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedCertificateResultToKotlin(getManagedCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the properties of a Managed Environment used to host container apps.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return An environment for hosting container apps
     */
    public suspend fun getManagedEnvironment(argument: GetManagedEnvironmentPlainArgs): GetManagedEnvironmentResult =
        getManagedEnvironmentResultToKotlin(getManagedEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getManagedEnvironment].
     * @param environmentName Name of the Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An environment for hosting container apps
     */
    public suspend fun getManagedEnvironment(environmentName: String, resourceGroupName: String): GetManagedEnvironmentResult {
        val argument = GetManagedEnvironmentPlainArgs(
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedEnvironmentResultToKotlin(getManagedEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetManagedEnvironmentPlainArgs].
     * @return An environment for hosting container apps
     */
    public suspend fun getManagedEnvironment(argument: suspend GetManagedEnvironmentPlainArgsBuilder.() -> Unit): GetManagedEnvironmentResult {
        val builder = GetManagedEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedEnvironmentResultToKotlin(getManagedEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Checks if resource name is available.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Environment Auth Token.
     */
    public suspend fun getManagedEnvironmentAuthToken(argument: GetManagedEnvironmentAuthTokenPlainArgs): GetManagedEnvironmentAuthTokenResult =
        getManagedEnvironmentAuthTokenResultToKotlin(getManagedEnvironmentAuthTokenPlain(argument.toJava()).await())

    /**
     * @see [getManagedEnvironmentAuthToken].
     * @param environmentName Name of the Managed Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Environment Auth Token.
     */
    public suspend fun getManagedEnvironmentAuthToken(
        environmentName: String,
        resourceGroupName: String,
    ): GetManagedEnvironmentAuthTokenResult {
        val argument = GetManagedEnvironmentAuthTokenPlainArgs(
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedEnvironmentAuthTokenResultToKotlin(getManagedEnvironmentAuthTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedEnvironmentAuthToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetManagedEnvironmentAuthTokenPlainArgs].
     * @return Environment Auth Token.
     */
    public suspend fun getManagedEnvironmentAuthToken(argument: suspend GetManagedEnvironmentAuthTokenPlainArgsBuilder.() -> Unit): GetManagedEnvironmentAuthTokenResult {
        val builder = GetManagedEnvironmentAuthTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedEnvironmentAuthTokenResultToKotlin(getManagedEnvironmentAuthTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Get storage for a managedEnvironment.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Storage resource for managedEnvironment.
     */
    public suspend fun getManagedEnvironmentsStorage(argument: GetManagedEnvironmentsStoragePlainArgs): GetManagedEnvironmentsStorageResult =
        getManagedEnvironmentsStorageResultToKotlin(getManagedEnvironmentsStoragePlain(argument.toJava()).await())

    /**
     * @see [getManagedEnvironmentsStorage].
     * @param environmentName Name of the Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageName Name of the storage.
     * @return Storage resource for managedEnvironment.
     */
    public suspend fun getManagedEnvironmentsStorage(
        environmentName: String,
        resourceGroupName: String,
        storageName: String,
    ): GetManagedEnvironmentsStorageResult {
        val argument = GetManagedEnvironmentsStoragePlainArgs(
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
            storageName = storageName,
        )
        return getManagedEnvironmentsStorageResultToKotlin(getManagedEnvironmentsStoragePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedEnvironmentsStorage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;GetManagedEnvironmentsStoragePlainArgs].
     * @return Storage resource for managedEnvironment.
     */
    public suspend fun getManagedEnvironmentsStorage(argument: suspend GetManagedEnvironmentsStoragePlainArgsBuilder.() -> Unit): GetManagedEnvironmentsStorageResult {
        val builder = GetManagedEnvironmentsStoragePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedEnvironmentsStorageResultToKotlin(getManagedEnvironmentsStoragePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the token used to connect to the endpoint where source code can be uploaded for a build.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-11-02-preview.
     * @param argument null
     * @return Build Auth Token.
     */
    public suspend fun listBuildAuthToken(argument: ListBuildAuthTokenPlainArgs): ListBuildAuthTokenResult =
        listBuildAuthTokenResultToKotlin(listBuildAuthTokenPlain(argument.toJava()).await())

    /**
     * @see [listBuildAuthToken].
     * @param buildName The name of a build.
     * @param builderName The name of the builder.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Build Auth Token.
     */
    public suspend fun listBuildAuthToken(
        buildName: String,
        builderName: String,
        resourceGroupName: String,
    ): ListBuildAuthTokenResult {
        val argument = ListBuildAuthTokenPlainArgs(
            buildName = buildName,
            builderName = builderName,
            resourceGroupName = resourceGroupName,
        )
        return listBuildAuthTokenResultToKotlin(listBuildAuthTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [listBuildAuthToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListBuildAuthTokenPlainArgs].
     * @return Build Auth Token.
     */
    public suspend fun listBuildAuthToken(argument: suspend ListBuildAuthTokenPlainArgsBuilder.() -> Unit): ListBuildAuthTokenResult {
        val builder = ListBuildAuthTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBuildAuthTokenResultToKotlin(listBuildAuthTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Dapr component Secrets Collection for ListSecrets Action.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listConnectedEnvironmentsDaprComponentSecrets(argument: ListConnectedEnvironmentsDaprComponentSecretsPlainArgs): ListConnectedEnvironmentsDaprComponentSecretsResult =
        listConnectedEnvironmentsDaprComponentSecretsResultToKotlin(listConnectedEnvironmentsDaprComponentSecretsPlain(argument.toJava()).await())

    /**
     * @see [listConnectedEnvironmentsDaprComponentSecrets].
     * @param componentName Name of the Dapr Component.
     * @param connectedEnvironmentName Name of the connected environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listConnectedEnvironmentsDaprComponentSecrets(
        componentName: String,
        connectedEnvironmentName: String,
        resourceGroupName: String,
    ): ListConnectedEnvironmentsDaprComponentSecretsResult {
        val argument = ListConnectedEnvironmentsDaprComponentSecretsPlainArgs(
            componentName = componentName,
            connectedEnvironmentName = connectedEnvironmentName,
            resourceGroupName = resourceGroupName,
        )
        return listConnectedEnvironmentsDaprComponentSecretsResultToKotlin(listConnectedEnvironmentsDaprComponentSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listConnectedEnvironmentsDaprComponentSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListConnectedEnvironmentsDaprComponentSecretsPlainArgs].
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listConnectedEnvironmentsDaprComponentSecrets(argument: suspend ListConnectedEnvironmentsDaprComponentSecretsPlainArgsBuilder.() -> Unit): ListConnectedEnvironmentsDaprComponentSecretsResult {
        val builder = ListConnectedEnvironmentsDaprComponentSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConnectedEnvironmentsDaprComponentSecretsResultToKotlin(listConnectedEnvironmentsDaprComponentSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Custom domain analysis.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Custom domain analysis.
     */
    public suspend fun listContainerAppCustomHostNameAnalysis(argument: ListContainerAppCustomHostNameAnalysisPlainArgs): ListContainerAppCustomHostNameAnalysisResult =
        listContainerAppCustomHostNameAnalysisResultToKotlin(listContainerAppCustomHostNameAnalysisPlain(argument.toJava()).await())

    /**
     * @see [listContainerAppCustomHostNameAnalysis].
     * @param containerAppName Name of the Container App.
     * @param customHostname Custom hostname.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Custom domain analysis.
     */
    public suspend fun listContainerAppCustomHostNameAnalysis(
        containerAppName: String,
        customHostname: String? = null,
        resourceGroupName: String,
    ): ListContainerAppCustomHostNameAnalysisResult {
        val argument = ListContainerAppCustomHostNameAnalysisPlainArgs(
            containerAppName = containerAppName,
            customHostname = customHostname,
            resourceGroupName = resourceGroupName,
        )
        return listContainerAppCustomHostNameAnalysisResultToKotlin(listContainerAppCustomHostNameAnalysisPlain(argument.toJava()).await())
    }

    /**
     * @see [listContainerAppCustomHostNameAnalysis].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListContainerAppCustomHostNameAnalysisPlainArgs].
     * @return Custom domain analysis.
     */
    public suspend fun listContainerAppCustomHostNameAnalysis(argument: suspend ListContainerAppCustomHostNameAnalysisPlainArgsBuilder.() -> Unit): ListContainerAppCustomHostNameAnalysisResult {
        val builder = ListContainerAppCustomHostNameAnalysisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listContainerAppCustomHostNameAnalysisResultToKotlin(listContainerAppCustomHostNameAnalysisPlain(builtArgument.toJava()).await())
    }

    /**
     * Container App Secrets Collection ARM resource.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container App Secrets Collection ARM resource.
     */
    public suspend fun listContainerAppSecrets(argument: ListContainerAppSecretsPlainArgs): ListContainerAppSecretsResult =
        listContainerAppSecretsResultToKotlin(listContainerAppSecretsPlain(argument.toJava()).await())

    /**
     * @see [listContainerAppSecrets].
     * @param containerAppName Name of the Container App.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Container App Secrets Collection ARM resource.
     */
    public suspend fun listContainerAppSecrets(containerAppName: String, resourceGroupName: String): ListContainerAppSecretsResult {
        val argument = ListContainerAppSecretsPlainArgs(
            containerAppName = containerAppName,
            resourceGroupName = resourceGroupName,
        )
        return listContainerAppSecretsResultToKotlin(listContainerAppSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listContainerAppSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListContainerAppSecretsPlainArgs].
     * @return Container App Secrets Collection ARM resource.
     */
    public suspend fun listContainerAppSecrets(argument: suspend ListContainerAppSecretsPlainArgsBuilder.() -> Unit): ListContainerAppSecretsResult {
        val builder = ListContainerAppSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listContainerAppSecretsResultToKotlin(listContainerAppSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Dapr component Secrets Collection for ListSecrets Action.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listDaprComponentSecrets(argument: ListDaprComponentSecretsPlainArgs): ListDaprComponentSecretsResult =
        listDaprComponentSecretsResultToKotlin(listDaprComponentSecretsPlain(argument.toJava()).await())

    /**
     * @see [listDaprComponentSecrets].
     * @param componentName Name of the Dapr Component.
     * @param environmentName Name of the Managed Environment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listDaprComponentSecrets(
        componentName: String,
        environmentName: String,
        resourceGroupName: String,
    ): ListDaprComponentSecretsResult {
        val argument = ListDaprComponentSecretsPlainArgs(
            componentName = componentName,
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return listDaprComponentSecretsResultToKotlin(listDaprComponentSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDaprComponentSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListDaprComponentSecretsPlainArgs].
     * @return Dapr component Secrets Collection for ListSecrets Action.
     */
    public suspend fun listDaprComponentSecrets(argument: suspend ListDaprComponentSecretsPlainArgsBuilder.() -> Unit): ListDaprComponentSecretsResult {
        val builder = ListDaprComponentSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDaprComponentSecretsResultToKotlin(listDaprComponentSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Container Apps Job Secrets Collection ARM resource.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
     * @param argument null
     * @return Container Apps Job Secrets Collection ARM resource.
     */
    public suspend fun listJobSecrets(argument: ListJobSecretsPlainArgs): ListJobSecretsResult =
        listJobSecretsResultToKotlin(listJobSecretsPlain(argument.toJava()).await())

    /**
     * @see [listJobSecrets].
     * @param jobName Job Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Container Apps Job Secrets Collection ARM resource.
     */
    public suspend fun listJobSecrets(jobName: String, resourceGroupName: String): ListJobSecretsResult {
        val argument = ListJobSecretsPlainArgs(
            jobName = jobName,
            resourceGroupName = resourceGroupName,
        )
        return listJobSecretsResultToKotlin(listJobSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listJobSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;app&#46;kotlin&#46;inputs&#46;ListJobSecretsPlainArgs].
     * @return Container Apps Job Secrets Collection ARM resource.
     */
    public suspend fun listJobSecrets(argument: suspend ListJobSecretsPlainArgsBuilder.() -> Unit): ListJobSecretsResult {
        val builder = ListJobSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listJobSecretsResultToKotlin(listJobSecretsPlain(builtArgument.toJava()).await())
    }
}
