@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.ContainerRegistryResponse
import com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.ContainerRegistryResponse.Companion.toKotlin as containerRegistryResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Builder].
 */
@PulumiTagMarker
public class BuilderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuilderArgs = BuilderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuilderArgsBuilder.() -> Unit) {
        val builder = BuilderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Builder {
        val builtJavaResource = com.pulumi.azurenative.app.Builder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Builder(builtJavaResource)
    }
}

/**
 * Information about the SourceToCloud builder resource.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Builder testBuilder /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/builders/{builderName}
 * ```
 */
public class Builder internal constructor(
    override val javaResource: com.pulumi.azurenative.app.Builder,
) : KotlinCustomResource(javaResource, BuilderMapper) {
    /**
     * List of mappings of container registries and the managed identity used to connect to it.
     */
    public val containerRegistries: Output<List<ContainerRegistryResponse>>?
        get() = javaResource.containerRegistries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        containerRegistryResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource ID of the container apps environment that the builder is associated with.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of a builder resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BuilderMapper : ResourceMapper<Builder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.Builder::class == javaResource::class

    override fun map(javaResource: Resource): Builder = Builder(
        javaResource as
            com.pulumi.azurenative.app.Builder,
    )
}

/**
 * @see [Builder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Builder].
 */
public suspend fun builder(name: String, block: suspend BuilderResourceBuilder.() -> Unit): Builder {
    val builder = BuilderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Builder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun builder(name: String): Builder {
    val builder = BuilderResourceBuilder()
    builder.name(name)
    return builder.build()
}
