@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.BuilderArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.ContainerRegistryArgs
import com.pulumi.azurenative.app.kotlin.inputs.ContainerRegistryArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about the SourceToCloud builder resource.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Builder testBuilder /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/builders/{builderName}
 * ```
 * @property builderName The name of the builder.
 * @property containerRegistries List of mappings of container registries and the managed identity used to connect to it.
 * @property environmentId Resource ID of the container apps environment that the builder is associated with.
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class BuilderArgs(
    public val builderName: Output<String>? = null,
    public val containerRegistries: Output<List<ContainerRegistryArgs>>? = null,
    public val environmentId: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.BuilderArgs> {
    override fun toJava(): com.pulumi.azurenative.app.BuilderArgs =
        com.pulumi.azurenative.app.BuilderArgs.builder()
            .builderName(builderName?.applyValue({ args0 -> args0 }))
            .containerRegistries(
                containerRegistries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BuilderArgs].
 */
@PulumiTagMarker
public class BuilderArgsBuilder internal constructor() {
    private var builderName: Output<String>? = null

    private var containerRegistries: Output<List<ContainerRegistryArgs>>? = null

    private var environmentId: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the builder.
     */
    @JvmName("lmqebauhnjxxqlba")
    public suspend fun builderName(`value`: Output<String>) {
        this.builderName = value
    }

    /**
     * @param value List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("jnuoloycshautcrv")
    public suspend fun containerRegistries(`value`: Output<List<ContainerRegistryArgs>>) {
        this.containerRegistries = value
    }

    @JvmName("lbndqhvywatgiend")
    public suspend fun containerRegistries(vararg values: Output<ContainerRegistryArgs>) {
        this.containerRegistries = Output.all(values.asList())
    }

    /**
     * @param values List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("lgyhfdinqtciuphc")
    public suspend fun containerRegistries(values: List<Output<ContainerRegistryArgs>>) {
        this.containerRegistries = Output.all(values)
    }

    /**
     * @param value Resource ID of the container apps environment that the builder is associated with.
     */
    @JvmName("lfbjpokncdrmpdxp")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("jbmdqdehbcpgbcwj")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vngrrpvddwcpjdbs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("htlfqkifwmeyfpqs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("smdduhyuglxcxkag")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the builder.
     */
    @JvmName("hvijiklaavrkllxa")
    public suspend fun builderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builderName = mapped
    }

    /**
     * @param value List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("ykiddqmmmdfsbetj")
    public suspend fun containerRegistries(`value`: List<ContainerRegistryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistries = mapped
    }

    /**
     * @param argument List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("fsemhkupjuudsttl")
    public suspend fun containerRegistries(argument: List<suspend ContainerRegistryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerRegistryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param argument List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("pmsyusyfmqbxqmog")
    public suspend fun containerRegistries(vararg argument: suspend ContainerRegistryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerRegistryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param argument List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("kwtnprhltwfjifwo")
    public suspend fun containerRegistries(argument: suspend ContainerRegistryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerRegistryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param values List of mappings of container registries and the managed identity used to connect to it.
     */
    @JvmName("tpbbmlukllolyaau")
    public suspend fun containerRegistries(vararg values: ContainerRegistryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerRegistries = mapped
    }

    /**
     * @param value Resource ID of the container apps environment that the builder is associated with.
     */
    @JvmName("jfeodxcbikjhyygp")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("onmsqwjgwkqkmpfv")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("xpujaubvkwsyfeli")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xdnvmwuvpkxpaehn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pvwkrnjfqgpwlkeb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qwlnvtpnqigroviu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("glfooxcxxcmjlijt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BuilderArgs = BuilderArgs(
        builderName = builderName,
        containerRegistries = containerRegistries,
        environmentId = environmentId,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
