@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.ConnectedEnvironmentStorageResponseProperties
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.ConnectedEnvironmentStorageResponseProperties.Companion.toKotlin as connectedEnvironmentStorageResponsePropertiesToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectedEnvironmentsStorage].
 */
@PulumiTagMarker
public class ConnectedEnvironmentsStorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectedEnvironmentsStorageArgs = ConnectedEnvironmentsStorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectedEnvironmentsStorageArgsBuilder.() -> Unit) {
        val builder = ConnectedEnvironmentsStorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectedEnvironmentsStorage {
        val builtJavaResource =
            com.pulumi.azurenative.app.ConnectedEnvironmentsStorage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectedEnvironmentsStorage(builtJavaResource)
    }
}

/**
 * Storage resource for connectedEnvironment.
 * Azure REST API version: 2022-10-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or update environments storage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedEnvironmentsStorage = new AzureNative.App.ConnectedEnvironmentsStorage("connectedEnvironmentsStorage", new()
 *     {
 *         ConnectedEnvironmentName = "env",
 *         Properties = new AzureNative.App.Inputs.ConnectedEnvironmentStoragePropertiesArgs
 *         {
 *             AzureFile = new AzureNative.App.Inputs.AzureFilePropertiesArgs
 *             {
 *                 AccessMode = AzureNative.App.AccessMode.ReadOnly,
 *                 AccountKey = "key",
 *                 AccountName = "account1",
 *                 ShareName = "share1",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         StorageName = "jlaw-demo1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewConnectedEnvironmentsStorage(ctx, "connectedEnvironmentsStorage", &app.ConnectedEnvironmentsStorageArgs{
 * 			ConnectedEnvironmentName: pulumi.String("env"),
 * 			Properties: &app.ConnectedEnvironmentStoragePropertiesArgs{
 * 				AzureFile: &app.AzureFilePropertiesArgs{
 * 					AccessMode:  pulumi.String(app.AccessModeReadOnly),
 * 					AccountKey:  pulumi.String("key"),
 * 					AccountName: pulumi.String("account1"),
 * 					ShareName:   pulumi.String("share1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StorageName:       pulumi.String("jlaw-demo1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsStorage;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsStorageArgs;
 * import com.pulumi.azurenative.app.inputs.ConnectedEnvironmentStoragePropertiesArgs;
 * import com.pulumi.azurenative.app.inputs.AzureFilePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedEnvironmentsStorage = new ConnectedEnvironmentsStorage("connectedEnvironmentsStorage", ConnectedEnvironmentsStorageArgs.builder()
 *             .connectedEnvironmentName("env")
 *             .properties(ConnectedEnvironmentStoragePropertiesArgs.builder()
 *                 .azureFile(AzureFilePropertiesArgs.builder()
 *                     .accessMode("ReadOnly")
 *                     .accountKey("key")
 *                     .accountName("account1")
 *                     .shareName("share1")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .storageName("jlaw-demo1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ConnectedEnvironmentsStorage jlaw-demo1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}
 * ```
 */
public class ConnectedEnvironmentsStorage internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ConnectedEnvironmentsStorage,
) : KotlinCustomResource(javaResource, ConnectedEnvironmentsStorageMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Storage properties
     */
    public val properties: Output<ConnectedEnvironmentStorageResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                connectedEnvironmentStorageResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectedEnvironmentsStorageMapper : ResourceMapper<ConnectedEnvironmentsStorage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ConnectedEnvironmentsStorage::class == javaResource::class

    override fun map(javaResource: Resource): ConnectedEnvironmentsStorage =
        ConnectedEnvironmentsStorage(
            javaResource as
                com.pulumi.azurenative.app.ConnectedEnvironmentsStorage,
        )
}

/**
 * @see [ConnectedEnvironmentsStorage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectedEnvironmentsStorage].
 */
public suspend fun connectedEnvironmentsStorage(
    name: String,
    block: suspend ConnectedEnvironmentsStorageResourceBuilder.() -> Unit,
): ConnectedEnvironmentsStorage {
    val builder = ConnectedEnvironmentsStorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectedEnvironmentsStorage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectedEnvironmentsStorage(name: String): ConnectedEnvironmentsStorage {
    val builder = ConnectedEnvironmentsStorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
