@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.AuthPlatformArgs
import com.pulumi.azurenative.app.kotlin.inputs.AuthPlatformArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.GlobalValidationArgs
import com.pulumi.azurenative.app.kotlin.inputs.GlobalValidationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.HttpSettingsArgs
import com.pulumi.azurenative.app.kotlin.inputs.HttpSettingsArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.IdentityProvidersArgs
import com.pulumi.azurenative.app.kotlin.inputs.IdentityProvidersArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.LoginArgs
import com.pulumi.azurenative.app.kotlin.inputs.LoginArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or Update Container App AuthConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerAppsAuthConfig = new AzureNative.App.ContainerAppsAuthConfig("containerAppsAuthConfig", new()
 *     {
 *         AuthConfigName = "current",
 *         ContainerAppName = "testcanadacentral",
 *         GlobalValidation = new AzureNative.App.Inputs.GlobalValidationArgs
 *         {
 *             UnauthenticatedClientAction = AzureNative.App.UnauthenticatedClientActionV2.AllowAnonymous,
 *         },
 *         IdentityProviders = new AzureNative.App.Inputs.IdentityProvidersArgs
 *         {
 *             Facebook = new AzureNative.App.Inputs.FacebookArgs
 *             {
 *                 Registration = new AzureNative.App.Inputs.AppRegistrationArgs
 *                 {
 *                     AppId = "123",
 *                     AppSecretSettingName = "facebook-secret",
 *                 },
 *             },
 *         },
 *         Platform = new AzureNative.App.Inputs.AuthPlatformArgs
 *         {
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "workerapps-rg-xj",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewContainerAppsAuthConfig(ctx, "containerAppsAuthConfig", &app.ContainerAppsAuthConfigArgs{
 * 			AuthConfigName:   pulumi.String("current"),
 * 			ContainerAppName: pulumi.String("testcanadacentral"),
 * 			GlobalValidation: &app.GlobalValidationArgs{
 * 				UnauthenticatedClientAction: app.UnauthenticatedClientActionV2AllowAnonymous,
 * 			},
 * 			IdentityProviders: &app.IdentityProvidersArgs{
 * 				Facebook: &app.FacebookArgs{
 * 					Registration: &app.AppRegistrationArgs{
 * 						AppId:                pulumi.String("123"),
 * 						AppSecretSettingName: pulumi.String("facebook-secret"),
 * 					},
 * 				},
 * 			},
 * 			Platform: &app.AuthPlatformArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("workerapps-rg-xj"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerAppsAuthConfig;
 * import com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs;
 * import com.pulumi.azurenative.app.inputs.GlobalValidationArgs;
 * import com.pulumi.azurenative.app.inputs.IdentityProvidersArgs;
 * import com.pulumi.azurenative.app.inputs.FacebookArgs;
 * import com.pulumi.azurenative.app.inputs.AppRegistrationArgs;
 * import com.pulumi.azurenative.app.inputs.AuthPlatformArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerAppsAuthConfig = new ContainerAppsAuthConfig("containerAppsAuthConfig", ContainerAppsAuthConfigArgs.builder()
 *             .authConfigName("current")
 *             .containerAppName("testcanadacentral")
 *             .globalValidation(GlobalValidationArgs.builder()
 *                 .unauthenticatedClientAction("AllowAnonymous")
 *                 .build())
 *             .identityProviders(IdentityProvidersArgs.builder()
 *                 .facebook(FacebookArgs.builder()
 *                     .registration(AppRegistrationArgs.builder()
 *                         .appId("123")
 *                         .appSecretSettingName("facebook-secret")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .platform(AuthPlatformArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .resourceGroupName("workerapps-rg-xj")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ContainerAppsAuthConfig current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/authConfigs/{authConfigName}
 * ```
 * @property authConfigName Name of the Container App AuthConfig.
 * @property containerAppName Name of the Container App.
 * @property globalValidation The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
 * @property httpSettings The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
 * @property identityProviders The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
 * @property login The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
 * @property platform The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ContainerAppsAuthConfigArgs(
    public val authConfigName: Output<String>? = null,
    public val containerAppName: Output<String>? = null,
    public val globalValidation: Output<GlobalValidationArgs>? = null,
    public val httpSettings: Output<HttpSettingsArgs>? = null,
    public val identityProviders: Output<IdentityProvidersArgs>? = null,
    public val login: Output<LoginArgs>? = null,
    public val platform: Output<AuthPlatformArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs =
        com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs.builder()
            .authConfigName(authConfigName?.applyValue({ args0 -> args0 }))
            .containerAppName(containerAppName?.applyValue({ args0 -> args0 }))
            .globalValidation(globalValidation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpSettings(httpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityProviders(identityProviders?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppsAuthConfigArgs].
 */
@PulumiTagMarker
public class ContainerAppsAuthConfigArgsBuilder internal constructor() {
    private var authConfigName: Output<String>? = null

    private var containerAppName: Output<String>? = null

    private var globalValidation: Output<GlobalValidationArgs>? = null

    private var httpSettings: Output<HttpSettingsArgs>? = null

    private var identityProviders: Output<IdentityProvidersArgs>? = null

    private var login: Output<LoginArgs>? = null

    private var platform: Output<AuthPlatformArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the Container App AuthConfig.
     */
    @JvmName("vccpieunfyendaay")
    public suspend fun authConfigName(`value`: Output<String>) {
        this.authConfigName = value
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("rmrticyeguxmstwu")
    public suspend fun containerAppName(`value`: Output<String>) {
        this.containerAppName = value
    }

    /**
     * @param value The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
     */
    @JvmName("cgpkeurgibjiadjv")
    public suspend fun globalValidation(`value`: Output<GlobalValidationArgs>) {
        this.globalValidation = value
    }

    /**
     * @param value The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
     */
    @JvmName("wknklncyciickdff")
    public suspend fun httpSettings(`value`: Output<HttpSettingsArgs>) {
        this.httpSettings = value
    }

    /**
     * @param value The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
     */
    @JvmName("iodaujulyxqpanmm")
    public suspend fun identityProviders(`value`: Output<IdentityProvidersArgs>) {
        this.identityProviders = value
    }

    /**
     * @param value The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
     */
    @JvmName("kuhieeektduywesf")
    public suspend fun login(`value`: Output<LoginArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
     */
    @JvmName("livjgweyobitppvv")
    public suspend fun platform(`value`: Output<AuthPlatformArgs>) {
        this.platform = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ueedubqpajhwkxhg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Container App AuthConfig.
     */
    @JvmName("veljjywwbmhpbnnn")
    public suspend fun authConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authConfigName = mapped
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("ieyyhiupoaufupno")
    public suspend fun containerAppName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerAppName = mapped
    }

    /**
     * @param value The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
     */
    @JvmName("wmatsrcquynctakk")
    public suspend fun globalValidation(`value`: GlobalValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalValidation = mapped
    }

    /**
     * @param argument The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
     */
    @JvmName("konvicaqnhhvdhta")
    public suspend fun globalValidation(argument: suspend GlobalValidationArgsBuilder.() -> Unit) {
        val toBeMapped = GlobalValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.globalValidation = mapped
    }

    /**
     * @param value The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
     */
    @JvmName("kybxqytiobwrvovg")
    public suspend fun httpSettings(`value`: HttpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpSettings = mapped
    }

    /**
     * @param argument The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
     */
    @JvmName("ibsxikmtcqtbputt")
    public suspend fun httpSettings(argument: suspend HttpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = HttpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpSettings = mapped
    }

    /**
     * @param value The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
     */
    @JvmName("knifxyyrkgmbyxwd")
    public suspend fun identityProviders(`value`: IdentityProvidersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviders = mapped
    }

    /**
     * @param argument The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
     */
    @JvmName("yuspbiujheyihxqf")
    public suspend fun identityProviders(argument: suspend IdentityProvidersArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProvidersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityProviders = mapped
    }

    /**
     * @param value The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
     */
    @JvmName("qgrhmitbbuwfsopl")
    public suspend fun login(`value`: LoginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
     */
    @JvmName("qyirjbpnswdevcyy")
    public suspend fun login(argument: suspend LoginArgsBuilder.() -> Unit) {
        val toBeMapped = LoginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
     */
    @JvmName("ijglqjqogoqtqbih")
    public suspend fun platform(`value`: AuthPlatformArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
     */
    @JvmName("opunesxrcwkcwuxo")
    public suspend fun platform(argument: suspend AuthPlatformArgsBuilder.() -> Unit) {
        val toBeMapped = AuthPlatformArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uttfdwgcshxxrjjw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ContainerAppsAuthConfigArgs = ContainerAppsAuthConfigArgs(
        authConfigName = authConfigName,
        containerAppName = containerAppName,
        globalValidation = globalValidation,
        httpSettings = httpSettings,
        identityProviders = identityProviders,
        login = login,
        platform = platform,
        resourceGroupName = resourceGroupName,
    )
}
