@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.GithubActionConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.GithubActionConfigurationResponse.Companion.toKotlin as githubActionConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContainerAppsSourceControl].
 */
@PulumiTagMarker
public class ContainerAppsSourceControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerAppsSourceControlArgs = ContainerAppsSourceControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerAppsSourceControlArgsBuilder.() -> Unit) {
        val builder = ContainerAppsSourceControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContainerAppsSourceControl {
        val builtJavaResource =
            com.pulumi.azurenative.app.ContainerAppsSourceControl(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContainerAppsSourceControl(builtJavaResource)
    }
}

/**
 * Container App SourceControl.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or Update Container App SourceControl
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerAppsSourceControl = new AzureNative.App.ContainerAppsSourceControl("containerAppsSourceControl", new()
 *     {
 *         Branch = "master",
 *         ContainerAppName = "testcanadacentral",
 *         GithubActionConfiguration = new AzureNative.App.Inputs.GithubActionConfigurationArgs
 *         {
 *             AzureCredentials = new AzureNative.App.Inputs.AzureCredentialsArgs
 *             {
 *                 ClientId = "<clientid>",
 *                 ClientSecret = "<clientsecret>",
 *                 TenantId = "<tenantid>",
 *             },
 *             ContextPath = "./",
 *             Image = "image/tag",
 *             RegistryInfo = new AzureNative.App.Inputs.RegistryInfoArgs
 *             {
 *                 RegistryPassword = "<registrypassword>",
 *                 RegistryUrl = "xwang971reg.azurecr.io",
 *                 RegistryUserName = "xwang971reg",
 *             },
 *         },
 *         RepoUrl = "https://github.com/xwang971/ghatest",
 *         ResourceGroupName = "workerapps-rg-xj",
 *         SourceControlName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewContainerAppsSourceControl(ctx, "containerAppsSourceControl", &app.ContainerAppsSourceControlArgs{
 * 			Branch:           pulumi.String("master"),
 * 			ContainerAppName: pulumi.String("testcanadacentral"),
 * 			GithubActionConfiguration: &app.GithubActionConfigurationArgs{
 * 				AzureCredentials: &app.AzureCredentialsArgs{
 * 					ClientId:     pulumi.String("<clientid>"),
 * 					ClientSecret: pulumi.String("<clientsecret>"),
 * 					TenantId:     pulumi.String("<tenantid>"),
 * 				},
 * 				ContextPath: pulumi.String("./"),
 * 				Image:       pulumi.String("image/tag"),
 * 				RegistryInfo: &app.RegistryInfoArgs{
 * 					RegistryPassword: pulumi.String("<registrypassword>"),
 * 					RegistryUrl:      pulumi.String("xwang971reg.azurecr.io"),
 * 					RegistryUserName: pulumi.String("xwang971reg"),
 * 				},
 * 			},
 * 			RepoUrl:           pulumi.String("https://github.com/xwang971/ghatest"),
 * 			ResourceGroupName: pulumi.String("workerapps-rg-xj"),
 * 			SourceControlName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerAppsSourceControl;
 * import com.pulumi.azurenative.app.ContainerAppsSourceControlArgs;
 * import com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs;
 * import com.pulumi.azurenative.app.inputs.AzureCredentialsArgs;
 * import com.pulumi.azurenative.app.inputs.RegistryInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerAppsSourceControl = new ContainerAppsSourceControl("containerAppsSourceControl", ContainerAppsSourceControlArgs.builder()
 *             .branch("master")
 *             .containerAppName("testcanadacentral")
 *             .githubActionConfiguration(GithubActionConfigurationArgs.builder()
 *                 .azureCredentials(AzureCredentialsArgs.builder()
 *                     .clientId("<clientid>")
 *                     .clientSecret("<clientsecret>")
 *                     .tenantId("<tenantid>")
 *                     .build())
 *                 .contextPath("./")
 *                 .image("image/tag")
 *                 .registryInfo(RegistryInfoArgs.builder()
 *                     .registryPassword("<registrypassword>")
 *                     .registryUrl("xwang971reg.azurecr.io")
 *                     .registryUserName("xwang971reg")
 *                     .build())
 *                 .build())
 *             .repoUrl("https://github.com/xwang971/ghatest")
 *             .resourceGroupName("workerapps-rg-xj")
 *             .sourceControlName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ContainerAppsSourceControl current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}
 * ```
 */
public class ContainerAppsSourceControl internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ContainerAppsSourceControl,
) : KotlinCustomResource(javaResource, ContainerAppsSourceControlMapper) {
    /**
     * The branch which will trigger the auto deployment
     */
    public val branch: Output<String>?
        get() = javaResource.branch().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time
     */
    public val githubActionConfiguration: Output<GithubActionConfigurationResponse>?
        get() = javaResource.githubActionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> githubActionConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current provisioning State of the operation
     */
    public val operationState: Output<String>
        get() = javaResource.operationState().applyValue({ args0 -> args0 })

    /**
     * The repo url which will be integrated to ContainerApp.
     */
    public val repoUrl: Output<String>?
        get() = javaResource.repoUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContainerAppsSourceControlMapper : ResourceMapper<ContainerAppsSourceControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ContainerAppsSourceControl::class == javaResource::class

    override fun map(javaResource: Resource): ContainerAppsSourceControl =
        ContainerAppsSourceControl(
            javaResource as
                com.pulumi.azurenative.app.ContainerAppsSourceControl,
        )
}

/**
 * @see [ContainerAppsSourceControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerAppsSourceControl].
 */
public suspend fun containerAppsSourceControl(
    name: String,
    block: suspend ContainerAppsSourceControlResourceBuilder.() -> Unit,
): ContainerAppsSourceControl {
    val builder = ContainerAppsSourceControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerAppsSourceControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerAppsSourceControl(name: String): ContainerAppsSourceControl {
    val builder = ContainerAppsSourceControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
