@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ContainerAppsSourceControlArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.GithubActionConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.GithubActionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container App SourceControl.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or Update Container App SourceControl
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerAppsSourceControl = new AzureNative.App.ContainerAppsSourceControl("containerAppsSourceControl", new()
 *     {
 *         Branch = "master",
 *         ContainerAppName = "testcanadacentral",
 *         GithubActionConfiguration = new AzureNative.App.Inputs.GithubActionConfigurationArgs
 *         {
 *             AzureCredentials = new AzureNative.App.Inputs.AzureCredentialsArgs
 *             {
 *                 ClientId = "<clientid>",
 *                 ClientSecret = "<clientsecret>",
 *                 TenantId = "<tenantid>",
 *             },
 *             ContextPath = "./",
 *             Image = "image/tag",
 *             RegistryInfo = new AzureNative.App.Inputs.RegistryInfoArgs
 *             {
 *                 RegistryPassword = "<registrypassword>",
 *                 RegistryUrl = "xwang971reg.azurecr.io",
 *                 RegistryUserName = "xwang971reg",
 *             },
 *         },
 *         RepoUrl = "https://github.com/xwang971/ghatest",
 *         ResourceGroupName = "workerapps-rg-xj",
 *         SourceControlName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewContainerAppsSourceControl(ctx, "containerAppsSourceControl", &app.ContainerAppsSourceControlArgs{
 * 			Branch:           pulumi.String("master"),
 * 			ContainerAppName: pulumi.String("testcanadacentral"),
 * 			GithubActionConfiguration: &app.GithubActionConfigurationArgs{
 * 				AzureCredentials: &app.AzureCredentialsArgs{
 * 					ClientId:     pulumi.String("<clientid>"),
 * 					ClientSecret: pulumi.String("<clientsecret>"),
 * 					TenantId:     pulumi.String("<tenantid>"),
 * 				},
 * 				ContextPath: pulumi.String("./"),
 * 				Image:       pulumi.String("image/tag"),
 * 				RegistryInfo: &app.RegistryInfoArgs{
 * 					RegistryPassword: pulumi.String("<registrypassword>"),
 * 					RegistryUrl:      pulumi.String("xwang971reg.azurecr.io"),
 * 					RegistryUserName: pulumi.String("xwang971reg"),
 * 				},
 * 			},
 * 			RepoUrl:           pulumi.String("https://github.com/xwang971/ghatest"),
 * 			ResourceGroupName: pulumi.String("workerapps-rg-xj"),
 * 			SourceControlName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerAppsSourceControl;
 * import com.pulumi.azurenative.app.ContainerAppsSourceControlArgs;
 * import com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs;
 * import com.pulumi.azurenative.app.inputs.AzureCredentialsArgs;
 * import com.pulumi.azurenative.app.inputs.RegistryInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerAppsSourceControl = new ContainerAppsSourceControl("containerAppsSourceControl", ContainerAppsSourceControlArgs.builder()
 *             .branch("master")
 *             .containerAppName("testcanadacentral")
 *             .githubActionConfiguration(GithubActionConfigurationArgs.builder()
 *                 .azureCredentials(AzureCredentialsArgs.builder()
 *                     .clientId("<clientid>")
 *                     .clientSecret("<clientsecret>")
 *                     .tenantId("<tenantid>")
 *                     .build())
 *                 .contextPath("./")
 *                 .image("image/tag")
 *                 .registryInfo(RegistryInfoArgs.builder()
 *                     .registryPassword("<registrypassword>")
 *                     .registryUrl("xwang971reg.azurecr.io")
 *                     .registryUserName("xwang971reg")
 *                     .build())
 *                 .build())
 *             .repoUrl("https://github.com/xwang971/ghatest")
 *             .resourceGroupName("workerapps-rg-xj")
 *             .sourceControlName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ContainerAppsSourceControl current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/sourcecontrols/{sourceControlName}
 * ```
 * @property branch The branch which will trigger the auto deployment
 * @property containerAppName Name of the Container App.
 * @property githubActionConfiguration Container App Revision Template with all possible settings and the
 * defaults if user did not provide them. The defaults are populated
 * as they were at the creation time
 * @property repoUrl The repo url which will be integrated to ContainerApp.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceControlName Name of the Container App SourceControl.
 */
public data class ContainerAppsSourceControlArgs(
    public val branch: Output<String>? = null,
    public val containerAppName: Output<String>? = null,
    public val githubActionConfiguration: Output<GithubActionConfigurationArgs>? = null,
    public val repoUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceControlName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ContainerAppsSourceControlArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ContainerAppsSourceControlArgs =
        com.pulumi.azurenative.app.ContainerAppsSourceControlArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .containerAppName(containerAppName?.applyValue({ args0 -> args0 }))
            .githubActionConfiguration(
                githubActionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .repoUrl(repoUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceControlName(sourceControlName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppsSourceControlArgs].
 */
@PulumiTagMarker
public class ContainerAppsSourceControlArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var containerAppName: Output<String>? = null

    private var githubActionConfiguration: Output<GithubActionConfigurationArgs>? = null

    private var repoUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceControlName: Output<String>? = null

    /**
     * @param value The branch which will trigger the auto deployment
     */
    @JvmName("tqfvxgcfkdolxark")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("xnlnakdxrqoytfkf")
    public suspend fun containerAppName(`value`: Output<String>) {
        this.containerAppName = value
    }

    /**
     * @param value Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time
     */
    @JvmName("odrfuoauybftpcfx")
    public suspend fun githubActionConfiguration(`value`: Output<GithubActionConfigurationArgs>) {
        this.githubActionConfiguration = value
    }

    /**
     * @param value The repo url which will be integrated to ContainerApp.
     */
    @JvmName("rmtifaandcnfvjbq")
    public suspend fun repoUrl(`value`: Output<String>) {
        this.repoUrl = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oahyvwyurrometrc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Container App SourceControl.
     */
    @JvmName("owhjtslfpwwhqeja")
    public suspend fun sourceControlName(`value`: Output<String>) {
        this.sourceControlName = value
    }

    /**
     * @param value The branch which will trigger the auto deployment
     */
    @JvmName("gfdcmtsbmohaaqbw")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("tkebcatwutpbklmw")
    public suspend fun containerAppName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerAppName = mapped
    }

    /**
     * @param value Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time
     */
    @JvmName("btivniejrtreywro")
    public suspend fun githubActionConfiguration(`value`: GithubActionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.githubActionConfiguration = mapped
    }

    /**
     * @param argument Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time
     */
    @JvmName("qcujgekxwkmsxxnu")
    public suspend fun githubActionConfiguration(argument: suspend GithubActionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GithubActionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.githubActionConfiguration = mapped
    }

    /**
     * @param value The repo url which will be integrated to ContainerApp.
     */
    @JvmName("cbqlelvqfktabavy")
    public suspend fun repoUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoUrl = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ytnhvfvvlgurwdlo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Container App SourceControl.
     */
    @JvmName("hhjcvhssugbhjbki")
    public suspend fun sourceControlName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceControlName = mapped
    }

    internal fun build(): ContainerAppsSourceControlArgs = ContainerAppsSourceControlArgs(
        branch = branch,
        containerAppName = containerAppName,
        githubActionConfiguration = githubActionConfiguration,
        repoUrl = repoUrl,
        resourceGroupName = resourceGroupName,
        sourceControlName = sourceControlName,
    )
}
